<?php
/*--------------------------------------------------------------------
 ReadServiceInterface.php 2020-2-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\AttributeInformation\Service;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Database\Price\AttributeInformation\Exceptions\NoAttributeOptionValuesIdInModifierCollectionFoundException;
use Gambio\Shop\SellingUnit\Database\Price\AttributeInformation\Repository\Dto\OptionIdOptionValuesIdDtoCollection;

/**
 * Interface ReadServiceInterface
 * @package Gambio\Shop\SellingUnit\Database\Price\AttributeInformation\Service
 */
interface ReadServiceInterface
{
    /**
     * @param ModifierIdentifierCollectionInterface $identifierCollection
     *
     * @param ProductId                             $productId
     *
     * @return OptionIdOptionValuesIdDtoCollection
     * @throws NoAttributeOptionValuesIdInModifierCollectionFoundException
     */
    public function getOptionIdOptionValuesId(
        ModifierIdentifierCollectionInterface $identifierCollection,
        ProductId $productId
    ): OptionIdOptionValuesIdDtoCollection;
}